/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.figures;

import CH.ifa.draw.framework.Connector;
import DE.siemens.ad.logo.model.BinaryInBlockConnector;
import DE.siemens.ad.logo.model.BlockConnector;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.SpecialBlock;
import DE.siemens.ad.logo.model.block.DeputyBlock;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.pdraw.figures.BlockIfcFigure;
import DE.siemens.ad.pdraw.figures.InputIfcTextFigure;
import DE.siemens.ad.pdraw.figures.constraints.FigureConstraint;
import DE.siemens.ad.pdraw.figures.constraints.InConnectorConstraint;
import DE.siemens.ad.pdraw.standard.LeftConnector;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.print.PrinterGraphics;

public class InputIfcFigure
extends BlockIfcFigure {
    static final long serialVersionUID = -8112483944798578788L;
    private int inputIfcFigureSerializedDataVersion = 1;
    protected transient InputIfcTextFigure fInputIfcTextFigure = null;

    public InputIfcFigure() {
    }

    public InputIfcFigure(BlockConnector bConnector) {
        this.fBlockConnector = bConnector;
        if (bConnector instanceof ParameterInBlockConnector) {
            this.setAttribute("FrameColor", new Color(51, 153, 51));
        }
    }

    public Connector connectorAt(int x, int y) {
        return new LeftConnector(this);
    }

    public FigureConstraint createConstraint() {
        return new InConnectorConstraint(this);
    }

    public void draw(Graphics g) {
        if (this.fBlockConnector.isNegated()) {
            Rectangle displayBox = this.displayBox();
            int radius = displayBox.width / 2;
            g.setColor(this.getFrameColor());
            g.fillOval(displayBox.x, displayBox.y - radius, displayBox.width, displayBox.width);
        } else {
            super.draw(g);
        }
        if ((g instanceof PrinterGraphics || g instanceof PrintGraphics || g instanceof Graphics2D && ((Graphics2D)g).getTransform().getScaleX() >= 1.5) && (this.fBlockConnector.getOwner() instanceof SpecialBlock || this.fBlockConnector.getOwner() instanceof DeputyBlock)) {
            if (this.fInputIfcTextFigure == null) {
                this.fInputIfcTextFigure = new InputIfcTextFigure();
                this.fInputIfcTextFigure.setText(((InBlockConnector)this.fBlockConnector).getName());
            }
            Dimension size = this.fInputIfcTextFigure.size();
            Font originFont = g.getFont();
            Font textFont = this.fInputIfcTextFigure.getFont();
            if (textFont != null) {
                g.setFont(textFont);
            }
            g.setColor(Color.black);
            Point p1 = (Point)this.fPoints.elementAt(0);
            Point p2 = (Point)this.fPoints.elementAt(1);
            g.drawString(this.fInputIfcTextFigure.getText(), Math.min(p1.x - 1, p1.x - (size.width - (p2.x - p1.x)) - 1), p1.y - 1);
            if (originFont != null) {
                g.setFont(originFont);
            }
        }
    }

    public void drawSimulation1(Graphics g) {
        InBlockConnector ibc = (InBlockConnector)this.getBlockConnector();
        if (ibc.getSignalType() == 0) {
            boolean value = ((BinaryInBlockConnector)ibc).getBinaryValue();
            Color oldColor = this.getFrameColor();
            Color color = value ? Global.SIMULATION_COLOR_HIGH : Global.SIMULATION_COLOR_LOW;
            this.setColor(color);
            this.draw(g);
            this.setColor(oldColor);
        } else {
            this.draw(g);
        }
    }
}

